<?php
require_once 'header.php';
?>

<div class="container ctwhite">

	<h1><?=translate('advert_rates')?></h1>
	
	<div class="alert alert-warning">
	<?=translate('adv_description')?>
	<br/>
	<?php if($usersObject->ID()) : ?>
		<a href="/new-campaign.php"><?=translate('create_cmp')?></a>
	<?php else: ?>
		<a href="/index.php"><?=translate('login_to_order')?></a>
	<?php endif; ?>
	</div>
	

	<table class="table table-bordered table-hover">
		<thead>
			<th><?=translate('country')?></th>
			<th><?=translate('country_code')?></th>
			<th><?=translate('price_per_k')?></th>
		</thead>
		<tbody>
			<?php
			$pricing = $db->get_results("SELECT pricing.pID, pricing.country, pricing.price_k, countries.country as cname  
			                           FROM pricing, countries WHERE pricing.country = countries.ccode ORDER BY price_k DESC");
			foreach($pricing as $p) {
				print '<tr>';
				print '<td>'.$p->cname.'</td>';
				print '<td>'.$p->country.'</td>';
				print '<td>$'.number_format($p->price_k, 0).'</td>';
				print '</tr>';
			}						
			?>
		</tbody>
	</table>

</div>

<?php
require_once 'footer.php';
?>